def median(x):
    s = sorted(x)
    if len(s) < 1:
        raise ValueError("Cannot calculate median of an empty input")
    if len(s) % 2 == 1:
        return s[len(s) / 2]
    return (s[len(s) / 2] + s[len(s) / 2 - 1]) / 2


# FIXME move under autocheck and split tests from this file
assert median([5, 2, 4, 0]) == 3
assert median([1, 3, 2]) == 2


def hodges_lehmann_diff(a, b):
    return median([y - x for x in a for y in b])


def hodges_lehmann_median(a):
    return median([(x + y)/2 for n, x in enumerate(a) for y in a[n:]])
