#!/usr/bin/python

from __future__ import print_function

import json
import time
import sys
import subprocess


def main():
    hp_process = None
    try:
        hp_process = subprocess.Popen(sys.argv[1])
        start_time = time.time()
        while True:
            print_smaps_stats(hp_process.pid, time.time() - start_time)
            time.sleep(1)
    finally:
        if hp_process is not None:
            hp_process.kill()


def print_smaps_stats(pid, ts):
    from smaps import read_smaps

    smaps = read_smaps(pid)
    anon_total = 0.0
    ahp_total = 0.0
    ahp_maps = 0
    for s in smaps:
        if not s:
            continue
        try:
            flags = s['VmFlags'].split()
        except KeyError:
            print("Skipped section with no VmFlags:\n%s" % json.dumps(s), file=sys.stderr)
            continue
        if 'hg' not in flags:
            continue
        ahp_maps += 1
        anon_total += int(s['Anonymous'])
        ahp_total += int(s['AnonHugePages'])
    print("%.2f %d %.2f %.2f %.4f" % (ts, ahp_maps, ahp_total/2**20, anon_total/2**20, 1.0 * ahp_total / anon_total if anon_total else 0))


if __name__ == '__main__':
    main()
