# -*- coding: utf-8 -*-

import sandbox.sandboxsdk.parameters as sp
from sandbox.projects.yabs.qa.resource_types import (
    YABS_MYSQL_ARCHIVE_CONTENTS,
    BS_RELEASE_YT,
    YABS_MYSQL_RESTORE_DESCRIPTION,
)


class BinDbList(sp.SandboxStringParameter):
    name = 'bin_db_list'
    default_value = 'dbc dbe dbis dbds dbm3 dbw st005 st017 st029 st041 st053 st065 st077 st089 st101 st113 st125 st137 st149'
    description = 'Space separated list of engine bin bases to restore sql tables for'
    group = 'Restore filters'


class FilterTable(sp.SandboxStringParameter):
    name = 'filter_table'
    default_value = '.*'
    description = 'Regexp to filter some tables by name'
    group = 'Restore filters'


class BackupDate(sp.SandboxStringParameter):
    name = 'backup_date'
    default_value = ''
    description = 'Backup date in YYYYMMDD format. Empty = current - 3h'
    group = 'Restore filters'


class Revision(sp.SandboxIntegerParameter):
    name = 'revision_num'
    description = 'Revision. Check out repo in this revision (0 = current)'
    required = False

# class ArcPath(sp.SandboxStringParameter):


class ArcPath(sp.SandboxArcadiaUrlParameter):
    name = 'arc_path'
    default_value = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yabs/server/'
    description = 'Path in arcadia.yandex.ru, included debian folder. Example: svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yabs/server/'
    required = True


class Option(object):
    NO_TABLES = 'no_tables'
    NO_LM_DUMPS = 'no_lm_dumps'
    SWITCH_TESTENV = 'testenv_switch_trigger'


class OptionsParameter(sp.SandboxBoolGroupParameter):
    name = 'options_list'
    description = 'extra options'
    choices = [
        ('Do not get tables', Option.NO_TABLES),
        ('Do not get linear model dumps', Option.NO_LM_DUMPS),
        ('Switch testenv to new resource', Option.SWITCH_TESTENV),
    ]
    default_value = ''


class PrevArchiveContents(sp.ResourceSelector):
    resource_type = YABS_MYSQL_ARCHIVE_CONTENTS
    name = 'prev_archive_contents_resource'
    description = 'Resource with previous archive contents.'


class BsReleaseYT(sp.ResourceSelector):
    resource_type = BS_RELEASE_YT
    name = 'bs_release_yt'
    description = 'Resource with dbtool'


class AdditionalRestoreDescription(sp.ResourceSelector):
    resource_type = YABS_MYSQL_RESTORE_DESCRIPTION
    name = 'additional_restore_description_resource'
    description = 'Resource with restore description for additional tables.'


class AdditionalRestoreDescriptionMD5(sp.SandboxStringParameter):
    name = 'additional_restore_description_resource_md5'
    description = 'Md5 of resource with restore description for additional tables.'
