import re
import json
import os
import subprocess
import urllib
import hashlib
import struct

m_handler = re.compile(r'^(?:POST|GET) /(code|page|meta|dsp)/')
m_page_id = re.compile(r'^(?:POST|GET) /(?:code|page|meta)/(\d+)(?:\?|\s)')
m_getparam_page_ref = re.compile(r'^(?:POST|GET) .*page-ref=([^ &]+)')
m_getparam_target_ref = re.compile(r'^(?:POST|GET) .*target-ref=([^ &]+)')
m_getparam_grab = re.compile(r'^(?:POST|GET) .*grab=([^ &]+)')
m_getparam_bigbxuniq_id = re.compile(r'^(?:POST|GET) .*(?:guid|uniq-id|crypta-id)=([^ &]+)')
m_referer = re.compile(r'^Referer:\s*(\S+)', re.IGNORECASE | re.MULTILINE)
m_re_referer = re.compile(r'^X-Yabs-Rereferer:\s*(\S+)', re.IGNORECASE | re.MULTILINE)
m_not_a_hacker = re.compile('i-m-not-a-hacker=[^,]+,')


def unpack_lzo(packed_message):
    ZX_PATH = os.getcwd()
    zx_packed_message_path = os.path.join(ZX_PATH, "zx_packed_message.txt")
    zx_unpacked_message_path = os.path.join(ZX_PATH, "zx_unpacked_message.txt")
    try:
        open(zx_packed_message_path, "w").write(packed_message)
        return subprocess.check_output(
            "cat " + zx_packed_message_path + " | yabs_unpack_bigb " +
            zx_unpacked_message_path + "; cat " + zx_unpacked_message_path,
            shell=True)
    finally:
        subprocess.check_output("echo '' > %s; echo '' > %s"
                                % (zx_packed_message_path,
                                   zx_unpacked_message_path),
                                shell=True)


def yabs_md5(msg):
    m = hashlib.md5()
    m.update(msg)
    s = m.digest()
    a = struct.unpack('>IIII', s)
    res = (a[1] ^ a[3]) << 32 | (a[0] ^ a[2])
    return res


class NoContext(Exception):
    """Indicates that no context targeting is needed for this request"""
    pass


class ContextTargetingParams(object):
    def __init__(self, request):
        handler = _extract(m_handler, request)
        if handler is None:
            raise NoContext  # No context targeting for this handler
        if handler in ('code', 'page', 'meta'):
            self.page_id = _extract(m_page_id, request)
            if self.page_id is None:
                raise ValueError("No page_id found")
            self.referer = _extract_unquoted(m_getparam_target_ref, request) or _extract(m_referer, request)
            self.grab = _extract(m_getparam_grab, request)
            self.re_referer = _extract_unquoted(m_getparam_page_ref, request) or _extract(m_re_referer, request)
            self.cookies = extract_cookies(request)
        elif handler == 'dsp':
            _, body = request.split("\r\n\r\n", 1)
            decoded_body = unpack_lzo(body)
            try:
                data = json.loads(decoded_body)
            except Exception:
                raise ValueError("Data in dsp.body.unpack_lzo should be valid JSON.")
            self.page_id = data['site']['id']
            self.referer = data['site'].get('referer')
            self.re_referer = data['site'].get('rereferer')
            self.cookies = {'yandexuid': data.get('user', {}).get('id')}
            self.grab = data['site'].get('grab')


def _extract(regexp, string):
    m = regexp.search(string)
    return m.group(1) if m else None


def _extract_unquoted(regexp, string):
    extr = _extract(regexp, string)
    return urllib.unquote(extr) if extr else None


def extract_cookies(request):
    cookie_str = None
    for line in request.splitlines():
        if line[:7].lower() == 'cookie:':
            cookie_str = line[7:]
            break
    print(cookie_str)
    if cookie_str is None:
        return {}

    cookies = {}
    for keyval in cookie_str.split(';'):
        keyval = m_not_a_hacker.sub('', keyval)
        kv = keyval.split('=')
        if len(kv) == 2:
            key = kv[0].strip()
            val = kv[1].strip()
            if key in ['yandexuid', 'fuid01']:
                cookies[key] = val

    return cookies


def extract_bigbxuniq_id(request):
    param = _extract(m_getparam_bigbxuniq_id, request)
    return yabs_md5(param) if param else None
