import re
import six
from itertools import islice


def split_with_delimiter_re(string, delimiter, maxsplits=-1):
    if isinstance(delimiter, six.string_types):
        regex_pattern = re.compile(delimiter)
    else:
        regex_pattern = re.compile('|'.join(delimiter))
    if maxsplits >= 0:
        regex_iterator = islice(regex_pattern.finditer(string), maxsplits)
    else:
        regex_iterator = regex_pattern.finditer(string)
    split_list = []
    last_index = 0
    for match in regex_iterator:
        end_index = match.span()[1]
        split_list.append(string[last_index:end_index])
        last_index = end_index
    if last_index != len(string) - 1:
        split_list.append(string[last_index:])
    return split_list


def split_with_delimiter(string, delimiter, maxsplits=-1):
    l = string.split(delimiter, maxsplits)
    if not l[-1]:
        l.pop()
        last_delimiter = delimiter
    else:
        last_delimiter = type(delimiter)()
    return_list = []
    for item in l[:-1]:
        return_list.append(item + delimiter)
    return_list.append(l[-1] + last_delimiter)
    return return_list


def delimited_file_read(file, delimiter='\n', bufsize=2*20, use_regex=False):
    if 'b' in file.mode:
        delimiter = six.b(delimiter)
    buf = type(delimiter)()
    split_function = split_with_delimiter_re if use_regex else split_with_delimiter
    while True:
        newbuf = file.read(bufsize)
        if not newbuf:
            if buf:
                yield buf
            return
        buf += newbuf
        split = split_function(buf, delimiter)
        for line in split[:-1]:
            yield line
        buf = split[-1]
