import json
import logging
import six
import subprocess
import sys
import traceback

from fcntl import fcntl, F_GETFL, F_SETFL
from os import O_NONBLOCK


class YabsFilterRecord(object):
    def __init__(self, filter_binary_path, exception_class=None, *args, **kwargs):
        super(YabsFilterRecord, self).__init__(*args, **kwargs)
        self.exception_class = exception_class
        try:
            self.__shader_process = subprocess.Popen(filter_binary_path, stdin=subprocess.PIPE, stdout=subprocess.PIPE, shell=False)
        except:
            self.handle_exception()
        flags = fcntl(self.__shader_process.stdout, F_GETFL)
        fcntl(self.__shader_process.stdout, F_SETFL, flags | O_NONBLOCK)

    def decode(self, str_to_decode):
        p = self.__shader_process
        if six.PY2:
            p.stdin.write(json.dumps(str_to_decode, ensure_ascii=False) + '\n')
        else:
            if isinstance(str_to_decode, bytes):
                str_to_decode = str_to_decode.decode()
            p.stdin.write((json.dumps(str_to_decode) + '\n').encode('utf-8'))
        while True:
            try:
                decoded = p.stdout.read()
                if decoded:
                    p.stdout.flush()
                    return json.loads(decoded.strip())
            except:
                pass

    def handle_exception(self):
        exc_type, exc_value, exc_traceback = sys.exc_info()
        logging.error('!!!EXCEPTION!!!')
        logging.error(repr(traceback.format_exception(exc_type, exc_value, exc_traceback)))
        result_exception_class = self.exception_class or exc_type
        logging.error('Raising {}'.format(repr(result_exception_class)))
        six.reraise(result_exception_class, exc_value, exc_traceback)
