import gzip
import shutil
import subprocess


def gzip_file(file_path, output_path=None):
    if output_path is None:
        output_path = file_path + '.gz'
    with open(file_path, 'rb') as f_in, gzip.open(output_path, 'wb') as f_out:
        shutil.copyfileobj(f_in, f_out)
    return output_path


def uc_compress(uc_executable_path, path_src, path_dest=None, pack_type='lz4hc'):
    if path_dest is None:
        path_dest = path_src + '.' + pack_type
    subprocess.check_call([
        uc_executable_path,
        '-c',
        '-C', pack_type,
        '-f', path_src,
        '-t', path_dest,
    ])
    return path_dest


def uc_decompress(uc_executable_path, path_src, path_dest=None, pack_type='lz4hc'):
    if path_dest is None:
        if '.' in path_src and path_src.rpartition()[-1] == pack_type:
            path_dest = path_src.rpartition()[0]
        else:
            path_dest = path_src + '.unpacked'
    subprocess.check_call([
        uc_executable_path,
        '-d',
        '-C', pack_type,
        '-f', path_src,
        '-t', path_dest,
    ])
    return path_dest
