# -*- encoding: utf-8 -*-

import json
import requests
import logging
from subprocess import check_output, CalledProcessError


class YabsGlobalInfo(object):
    @classmethod
    def _get_source_hosts(cls):
        r = requests.get("http://juggler-api.search.yandex.net/api/proxy/groups/expand?uri=yabs_bsbackup&do=1&group_type=CGROUP")
        return json.loads(r.text).keys()

    @classmethod
    def rsync_exec(cls, rsync_params_getter):
        succeed = False
        result = None
        for host in cls._get_source_hosts():
            try:
                rsync_params = rsync_params_getter(host)
                logging.info("calling rsync with params {rsync_params} accessing host {host}".format(
                    rsync_params=rsync_params, host=host))
                result = check_output(["rsync"] + rsync_params)
                logging.info("succeeded doing command on host {host}".format(host=host))
                succeed = True
                break
            except CalledProcessError as e:
                logging.warn("Cannot download host-options from %s: %s", host, e.message)
        if not succeed:
            raise BaseException("Cannot access rsync")
        return result

    @classmethod
    def get_srcs_to_register(cls):
        return cls.SOURCE_FILES

    @classmethod
    def get_rsync_download_params(cls, host):
        return ["{host}::global-info-ro/{path}{file}".format(host=host, path=cls.PATH, file=f) for f in cls.SOURCE_FILES] + ["./"]

    @classmethod
    def get_rsync_list_params(cls, path):
        def get_params(host):
            return ["--list-only", "{host}::global-info-ro/{path}".format(path=path, host=host)]
        return get_params

    @classmethod
    def download(cls):
        cls.rsync_exec(cls.get_rsync_download_params)
        return cls.get_srcs_to_register()
