# -*- encoding: utf-8 -*-

from sandbox.projects.common.yabs.yabs_global_info import YabsGlobalInfo
from sandbox.projects.yabs.global_info.resources import YABS_SHARDED_TIMESTATS4


class YabsShardedTimestats4(YabsGlobalInfo):
    RESOURCE_TYPE = YABS_SHARDED_TIMESTATS4
    RESULT_FILE = "timestats4"

    @classmethod
    def get_rsync_download_params(cls, host):
        return ["{host}::global-info-ro/timestats/timestats4/*".format(host=host), "./"]

    @classmethod
    def get_srcs_to_register(cls):
        raw_file_list = cls.rsync_exec(cls.get_rsync_list_params("timestats/timestats4/"))
        file_list = []
        for file_string in raw_file_list.rstrip().split('\n'):
            filename = file_string.split(' ')[-1]
            if filename[0] != '.':
                file_list.append(filename)
        return file_list
