# coding: utf-8

"""
FIXME
"""

from __future__ import division
from __future__ import unicode_literals

import os
import tarfile

from sandbox import sdk2
import sandbox.common.types.resource as ctr
from sandbox.sdk2.helpers import subprocess

from sandbox.projects.resource_types import PYTHON_BUNDLE, PYTHON_VIRTUALENV
from sandbox.projects.common.yappy.github import BuildWithGithubTask


class BaseBuildPythonBundle(BuildWithGithubTask):
    class Parameters(BuildWithGithubTask.Parameters):
        with sdk2.parameters.Group('Virtual environment') as block_virtualenv:
            virtualenv_archive = sdk2.parameters.Resource(
                'Virtual environment archive',
                resource_type=PYTHON_VIRTUALENV,
                state=(ctr.State.READY,),
                required=True
            )

        with sdk2.parameters.Group('Requirements') as block_requirements:
            use_requirements_file = sdk2.parameters.Bool('Use requirements file')
            use_wheels = sdk2.parameters.Bool('Use wheels')
            use_internal_pypi = sdk2.parameters.Bool('Use internal PyPi')
            do_not_use_pypi = sdk2.parameters.Bool('Do not use PyPi', default=True)
            verbose_pip = sdk2.parameters.Bool('Verbose pip output', default=True)

            with use_wheels.value[True]:
                wheels_dir = sdk2.parameters.String('Wheels directory', default='wheel')

            with use_requirements_file.value[True]:
                requirements_file = sdk2.parameters.String('Requirements file', default='requirements.txt')

        with sdk2.parameters.Group('PyPi') as block_pypi:
            pass

    class Context(BuildWithGithubTask.Context):
        virtualenv_path = None
        python_bin = None
        lib_path = None

    class Requirements(BuildWithGithubTask.Requirements):
        pass

    @property
    def github_context(self):
        raise NotImplementedError

    @property
    def bundle_description(self):
        raise NotImplementedError

    @property
    def bundle_resource_type(self):
        return PYTHON_BUNDLE

    def before_install(self):
        with self.info_section('<setup> virtualenv'):
            installation_dir = str(self.path('virtualenv_installation_dir'))

            virtualenv_archive = str(sdk2.ResourceData(self.Parameters.virtualenv_archive).path)
            with tarfile.open(virtualenv_archive) as a:
                a.extractall(installation_dir)

            self.Context.virtualenv_path = installation_dir
            self.Context.python_bin = os.path.abspath(os.path.join(installation_dir, 'ENV', 'bin', 'python'))
            self.Context.lib_path = os.path.abspath(os.path.join(installation_dir, 'ENV', 'lib'))

    def run_command(self, command, process_log, check_output=False, env=None):
        target_env = {
            'PYTHONPATH': self.Context.lib_path,
            'LD_LIBRARY_PATH': self.Context.lib_path,
        }
        if env is not None:
            target_env.update(env)

        kwargs = dict(
            cwd=self.Context.sources_path,
            stdout=process_log.stdout, stderr=process_log.stderr,
            env=target_env,
        )

        func = subprocess.check_call
        if check_output:
            func = subprocess.check_output
            kwargs.pop('stdout')

        return func(command, **kwargs)

    def run_pip_install(self, target, process_log):
        """
        FIXME

        :type target: list
        :type process_log:
        :rtype:
        """
        install_command = [self.Context.python_bin, '-m', 'pip', 'install']

        if self.Parameters.do_not_use_pypi:
            install_command.append('--no-index')
        if self.Parameters.use_wheels:
            install_command.extend(['--find-links', self.Parameters.wheels_dir])
        if self.Parameters.verbose_pip:
            install_command.append('--verbose')

        final_command = install_command[:]
        final_command.extend(target)

        return self.run_command(final_command, process_log)

    def install(self):
        if self.Parameters.use_requirements_file:
            with self.info_section('<install> requirements'), sdk2.helpers.ProcessLog(self, 'install_reqs') as pl:
                self.run_pip_install(['-r', self.Parameters.requirements_file], pl)

        with self.info_section('<install> target'), sdk2.helpers.ProcessLog(self, 'install_target') as pl:
            self.run_pip_install([self.Context.sources_path], pl)

    def build(self):
        pass

    def after_build(self, additional_bundled_files=None):
        with self.info_section('<bundle>'):
            with tarfile.TarFile('bundle.tar.gz', 'w') as tar:
                tar.add(self.Context.virtualenv_path, '.')

                for additional_file, path in additional_bundled_files or []:
                    tar.add(additional_file, path)

            self.create_resource(self.bundle_resource_type, self.bundle_description, 'bundle.tar.gz')
