import os
import logging


def get_old_tables(yt_client, dir_path, last_tables_count=3):
    assert yt_client.get_attribute(dir_path, 'type') == 'map_node', "wrong node directory type"
    assert last_tables_count >= 0, "last_tables_count mustn't be negative"

    tables = sorted(yt_client.list(dir_path))
    return tables[:-last_tables_count]


def clean_history_folder(yt_client, dir_path, last_tables_count=3):
    for useless_table in get_old_tables(yt_client, dir_path, last_tables_count):
        full_path = os.path.join(dir_path, useless_table)
        assert yt_client.get_attribute(full_path, 'type') == 'table', "try to remove not table"

        logging.info('remove {}'.format(full_path))
        yt_client.remove(full_path)
