# coding: utf-8
from __future__ import absolute_import, print_function

import os
import sys
import socket
import traceback

import mock
import pytest
import gevent.monkey

PROJECTS_PAR_DIR = os.path.dirname(os.path.dirname(__file__))
for _path in [os.path.dirname(PROJECTS_PAR_DIR), PROJECTS_PAR_DIR]:
    if _path not in sys.path:
        sys.path.append(_path)

from sandbox import common
common.import_hook.setup_sandbox_namespace()


def generate_assert_mock(name):
    def hook(*args, **kws):
        traceback.print_stack()
        msg = (
            "\nASSERT! {} usage from __init__() or task module is denied. "
            "The problematic task module is in the above stacktrace."
        ).format(name)
        print(msg, file=sys.stderr)
        os._exit(1)

    return hook


def mock_gevent_patch():
    for name in dir(gevent.monkey):
        if name.startswith("patch_"):
            setattr(
                gevent.monkey,
                name,
                generate_assert_mock("gevent.monkey.{}".format(name))
            )


def mock_socket_functions():
    common.utils.HostInfo.dc = mock.Mock(return_value='tst')
    socket.getfqdn = mock.Mock(return_value="test.example.org")

    for name in ("create_connection", "gethostbyname", "gethostbyname_ex", "gethostbyaddr"):
        setattr(
            socket,
            name,
            generate_assert_mock("socket.{}".format(name))
        )

    for name in ("connect", "bind", "accept"):
        setattr(
            socket.socket,
            name,
            generate_assert_mock("socket.socket.{}".format(name)),
        )


def pytest_configure(config):
    # `urllib3` uses a socket during its import to check for IPv6 support, see `urllib3.util.connection._has_ipv6()`.
    # Being imported during tasks tests, it triggers the socket assertions installed below.
    # Here we import `urllib3` beforehand to prevent this. See also SANDBOX-6605.

    # noinspection PyUnresolvedReferences
    import urllib3  # noqa

    mock_socket_functions()
    mock_gevent_patch()


def pytest_addoption(parser):
    parser.addoption("--sandbox-dir", type="string", action="store", default="", help="Path to Sandbox.")
    parser.addoption("--tests", type="string", action="store", default="", help="Tests filters.")
    parser.addoption("--run-long-tests", action="store_true", help="Run long tests.")


@pytest.mark.optionalhook
def pytest_html_results_table_row(report, cells):
    if report.passed or report.skipped:
        del cells[:]
