from sandbox import sdk2


class ContextServiceBinary(sdk2.Resource):
    """
    Binary for launching a service at context
    """

    releasable = True
    releasers = ['CONTEXT']
    auto_backup = True


class YacoshareResource(sdk2.Resource):
    """
    It may be any file (or directory) shared by yacoshare
    """

    releasable = True
    releasers = ['CONTEXT']
    auto_backup = True


class ContextYacoshareServerBin(sdk2.Resource):  # TODO remove when not needed
    """
    Yacoshare server binary file
    """

    releasable = True
    releasers = ['CONTEXT']
    auto_backup = True


class YacoshareServer(sdk2.Resource):
    """
    Yacoshare server binary file
    """

    releasable = True
    releasers = ['CONTEXT']
    auto_backup = True


class ContextYacoshareClientBin(sdk2.Resource):  # TODO remove when not needed
    """
    Yacoshare client binary file
    """

    releasable = True
    releasers = ['CONTEXT']
    auto_backup = True


class YacoshareClient(sdk2.Resource):
    """
    Yacoshare client binary file
    """

    releasable = True
    releasers = ['CONTEXT']
    auto_backup = True


class ContextMasterMirrors(sdk2.Resource):
    """
    Master mirrors map for url normalization.
    """

    auto_backup = True
    releasable = True
    releasers = ['CONTEXT']


class ContextRobotsCleanParams(sdk2.Resource):
    """
    Robots clean params for url normalization.
    """

    auto_backup = True
    releasable = True
    releasers = ['CONTEXT']


class ContextRobotsYandexDirect(sdk2.Resource):
    """
    Robots rules for YandexDirect UA.
    """

    auto_backup = True
    releasable = True
    releasers = ['CONTEXT']


class ContextDssmModel(sdk2.Resource):
    """
    Context DSSM model
    """

    releasable = True
    releasers = ['CONTEXT']
    auto_backup = True
    yacoshare_name = sdk2.parameters.String("Yacoshare Name", required=True)


class ContextMlModel(sdk2.Resource):
    """
    Context ML model
    """

    releasable = True
    releasers = ['CONTEXT']
    auto_backup = True
    model_type = sdk2.parameters.String("Model Type", required=True)
    yacoshare_name = sdk2.parameters.String("Yacoshare Name", required=True)


class SearchCtrTsarModel(sdk2.Resource):
    """
    Search ctr tsar model
    """

    releasable = True
    releasers = ['brutalman', 'CONTEXT']
    model_name = sdk2.parameters.String("Model name", required=True)


class BrutalTsarModel(sdk2.Resource):
    """
    Search ctr tsar model
    """

    releasable = True
    releasers = ['brutalman', 'CONTEXT']
    model_name = sdk2.parameters.String("Model name", required=True)


class BrutalRsyaCtrTsarModel(sdk2.Resource):
    """
    Search ctr tsar model
    """

    releasable = True
    releasers = ['brutalman', 'CONTEXT']
    model_name = sdk2.parameters.String("Model name", required=True)


class BrutalRsyaCtrTsarModel2(sdk2.Resource):
    """
    Search ctr tsar model
    """

    releasable = True
    releasers = ['brutalman', 'CONTEXT']
    model_name = sdk2.parameters.String("Model name", required=True)
