# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from datetime import datetime

import dateutil.parser
import re


ARRAY_KEY_PATTERN = re.compile(r"^\[(.*)\]$")


class PathPair(object):
    def __init__(self, path, value):
        self.path = path
        self.value = value


def child_item_extractor(current_item, path, value):
    child_item = None

    try:
        match = ARRAY_KEY_PATTERN.match(path)
        if type(current_item) is list and match:
            patter_array_key, pattern_array_value = match.group(1).split("==")

            for sub_item in current_item:
                child_item = child_item_extractor(sub_item, patter_array_key, pattern_array_value)
                if child_item:
                    break
        else:
            child_item = current_item[path]
    except TypeError:
        try:
            index = current_item.index(path)
            child_item = current_item[index]
        except (AttributeError, ValueError):
            child_item = getattr(current_item, path.encode('utf-8'))

    if child_item and value and child_item != value:
        return None

    return child_item


def process_modifier(ticket, current_score, modifier):
    field, value = modifier.split(":")
    fields_array = field.split("/")
    path_array = []

    for f in fields_array:
        if ARRAY_KEY_PATTERN.match(f):  # [id==10]
            path_array.append(PathPair(f, None))
        elif "==" in f:  # id==20
            path_field, path_field_expected_value = f.split("==")
            path_array.append(PathPair(path_field, path_field_expected_value))
        else:  # id
            path_array.append(PathPair(f, None))

    current_item = ticket

    age = (datetime.now() - dateutil.parser.parse(ticket.createdAt).replace(tzinfo=None)).days

    try:
        if field == '__age':
            current_item = age
        else:
            for path_pair in path_array:
                current_item = child_item_extractor(current_item, path_pair.path, path_pair.value)

        if current_item is None:
            return current_score

        modifier = 1.0

        if value.startswith("f"):
            modifier = float(current_item)
            value = value.split("f")[1]

        if value.startswith("*"):
            return current_score * modifier * float(value.split("*")[1])

        if value.startswith("+"):
            return current_score + modifier * float(value.split("+")[1])

        if value.startswith("-"):
            return current_score - modifier * float(value.split("-")[1])

    except AttributeError:
        pass

    return current_score


def process_deadline(ticket, current_score, deadline_addon, deadline_reaction):
    if ticket.deadline and deadline_addon > 0:
        delta = datetime.now() - dateutil.parser.parse(ticket.deadline)
        if delta.total_seconds() > 0:
            current_score += deadline_addon
        else:
            current_score += (deadline_addon/2.0)*2.0**(1.0+(float(delta.days)/float(deadline_reaction)))

    return current_score
