import logging
import datetime
import sys
from sandbox import sdk2


class CrmChToYt(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        targetPath = sdk2.parameters.String("Target Path", default="", multiline=False)
        YQL_TOKEN = sdk2.parameters.String("YQL_TOKEN", default="", multiline=False)
        YT_TOKEN = sdk2.parameters.String("YT_TOKEN", default="", multiline=False)

    class Requirements(sdk2.Task.Requirements):
        environments = [
            sdk2.environments.PipEnvironment("yql"),
            sdk2.environments.PipEnvironment("yandex-yt"),
            sdk2.environments.PipEnvironment("yandex-yt-yson-bindings"),
        ]

    def get_target_date(self):
        today = datetime.date.today()
        return today - datetime.timedelta(days=1)

    def get_rows_count(self):
        from yql.api.v1.client import YqlClient
        print(sys.version_info)
        client = YqlClient(token=self.Parameters.YQL_TOKEN)
        target_date = self.get_target_date()
        query = """
        USE rumclickhouse;
        SELECT count() as count
        FROM rum.errors
        WHERE
            project = 'crm-space'
            AND date = '{target_date}'
        """.format(target_date=target_date)
        requestCount = client.query(query, syntax_version=1, clickhouse_syntax=True)
        requestCount.run()
        return requestCount.get_results().table.rows[0][0]

    def get_data_chunk(self, rows_count):
        from yql.api.v1.client import YqlClient
        print('iteration is %s', rows_count)
        client = YqlClient(token=self.Parameters.YQL_TOKEN)
        results = []
        target_date = self.get_target_date()
        count = 1000
        number = 0
        while number < (rows_count / count) :
            offset = count * number
            query = """USE rumclickhouse;
            SELECT *
            FROM rum.errors
            WHERE
            project = 'crm-space'
            AND date = '{target_date}'
            LIMIT {count}
            OFFSET {offset}
            """.format(target_date=target_date, count=count, offset=offset)
            request = client.query(query, syntax_version=1, clickhouse_syntax=True)
            request.run()
            res = request.get_results()
            headers = res.table.column_names
            rows = res.table.rows
            for row in rows:
                rowAsObject = {}
                for idx, header in enumerate(headers):
                    rowAsObject[header] = row[idx]
                results.append(rowAsObject)
            print(len(results))
            number = number+1
        return results

    def on_execute(self):
        import yt.wrapper
        rows_count = self.get_rows_count()
        logging.info("rows count: %s", rows_count)
        results = self.get_data_chunk(rows_count=rows_count)
        logging.info("results len is: %s", len(results))
        target_date = self.get_target_date()
        clientYt = yt.wrapper.YtClient(proxy="hahn", token=self.Parameters.YT_TOKEN)
        table = '//home/crm/rum/rum-errors/{target_date}'.format(target_date=target_date)
        clientYt.write_table(table, format=yt.wrapper.format.JsonFormat(attributes={"encode_utf8": False}), input_stream=results)
        logging.info("Success! logs were copied!")
