import os

from sandbox import sdk2

from sandbox.projects.crypta.common.helpers import (
    STABLE,
    TESTING
)
from sandbox.projects.crypta.common import vault
from sandbox.projects.crypta.common.task import CryptaTask


AUDIENCE_TVM_SECRET = {
    STABLE: "sec-01dq7mdqc2yn2n8d9r2s2d5ys1[client_secret]",
    TESTING: "sec-01dq7mdq49h6wegxz835zg40ws[client_secret]",
}

CRYPTA_API_TVM_SECRET = "sec-01csvzetmmm9jphwm3bsp7c9ej[secret]"
CRYPTA_API_TVM_ID = "2000759"


class CryptaAudienceBundle(sdk2.Resource):
    releasable = True


class CryptaAudience(CryptaTask):

    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaAudienceBundle
        graphite_monitoring_task_name = "crypta-audience"
        use_semaphore = False

    class Parameters(CryptaTask.Parameters):
        task_name = sdk2.parameters.String("Task name")
        task_args = sdk2.parameters.Dict("Task parameters")
        options = sdk2.parameters.List("Additional command line arguments")

    def task_parameters(self):
        for (key, value) in (self.Parameters.task_args or {}).items():
            yield "--arg"
            yield "{}={}".format(key, value)

    def get_additional_env(self):
        env = {
            'CRYPTA_ENVIRONMENT': self.Parameters.environment.replace('stable', 'production'),
            'STATFACE_TOKEN': vault.get_statface_token(),
            'YT_POOL': 'crypta_audience',
            'CRYPTA_AUDIENCE_TVM_SECRET': vault.get_vault_item(AUDIENCE_TVM_SECRET[self.Parameters.environment]),
            'SANDBOX_OAUTH_TOKEN': vault.get_snbx_token(self.Parameters.environment),
            'TVM_ID': CRYPTA_API_TVM_ID,
            'TVM_SECRET': vault.get_vault_item(CRYPTA_API_TVM_SECRET),
        }

        return env

    @classmethod
    def get_juggler_service_for_task_name(cls, task_name):
        return "{}_{}".format(cls.get_class_juggler_service(), task_name)

    def get_juggler_service(self):
        return self.get_juggler_service_for_task_name(self.Parameters.task_name)

    def get_cmd(self):
        return [
            os.path.abspath("crypta-audience"),
        ] + list(self.Parameters.options) + [
            'run',
            '--task',
            self.Parameters.task_name,
        ] + list(self.task_parameters())
