from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task,
    vault,
)


class CryptaBuchhalterBundle(sdk2.Resource):
    releasable = True


class TaskName(object):
    adfox_calc = "adfox_calc"
    audience_add_logins_to_segments = "audience_add_logins_to_segments"
    audience_dmp_report_calc = "audience_dmp_report_calc"
    audience_filter_shared_chevents = "audience_filter_shared_chevents"
    audience_group_segments = "audience_group_segments"
    audience_per_group_calc = "audience_per_group_calc"
    audience_per_owner_calc = "audience_per_owner_calc"
    audience_per_segment_events_calc = "audience_per_segment_events_calc"
    audience_per_segment_login_metrics = "audience_per_segment_login_metrics"
    audience_send_shadow_dmp_reports = "audience_send_shadow_dmp_reports"
    audience_shadow_dmp_report_calc = "audience_shadow_dmp_report_calc"
    audience_shadow_dmps_calc = "audience_shadow_dmps_calc"
    backuper = "backuper"
    direct_calc = "direct_calc"
    display_calc = "display_calc"
    lookalike_calc = "lookalike_calc"
    multipliers_calc = "multipliers_calc"


class CryptaBuchhalterTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaBuchhalterBundle
        templates = ["{{task_name}}/config.yaml"]
        cmd = [
            helpers.get_abspath("crypta-buchhalter"),
            "--config", helpers.get_abspath("{{task_name}}/config.yaml"),
            "{{task_name}}",
        ]
        cmd_task_extras = {
            TaskName.audience_group_segments: [
                "--adobe-index", "adobe_index.yaml",
                "--dmp-index", "dmp_index.yaml",
                "--groups", "groups.yaml",
                "--shadow-dmp-index", "shadow_dmp_index.yaml",
            ],
            TaskName.audience_shadow_dmp_report_calc: [
                "--index", "shadow_dmp_index.yaml",
            ],
            TaskName.audience_shadow_dmps_calc: [
                "--dmp-index", "dmp_index.yaml",
                "--adobe-index", "adobe_index.yaml",
                "--block-lists", "block_lists.yaml",
            ],
        }

    def get_additional_env(self):
        return {
            "CRYPTA_AUDIENCE_OAUTH_TOKEN": vault.get_vault_item("sec-01d2fgsbpp4m34w5mbjrpb8fyv[token]"),
            "CRYPTA_AUDIENCE_TVM_SECRET": vault.get_vault_item("sec-01dq7mn0thkkxkzdjsc56q0mgx[client_secret]"),
        }
