import tarfile

from sandbox import sdk2
from sandbox.projects.bsyeti import (
    make_bigb_ab_experiment_config,
    make_config_json,
)
from sandbox.projects.common.juggler import jclient
from sandbox.projects.crypta.common import helpers


class CryptaBigbExperimentConfig(sdk2.Resource):
    st_source_id = sdk2.parameters.Integer("Select type resource ID", required=True)
    ab_source_id = sdk2.parameters.Integer("AB config resource ID", required=True)
    releasable = True


class CryptaCloneBigbExperimentConfig(sdk2.Task):
    def on_execute(self):
        last_cloned_resource = helpers.get_last_released_resource_unsafe(CryptaBigbExperimentConfig, helpers.PRESTABLE)
        st_config_resource = helpers.get_last_released_resource(make_config_json.BsYetiLightConfigs, helpers.STABLE)
        ab_config_resource = helpers.get_last_released_resource(make_bigb_ab_experiment_config.BigbAbExperimentsProductionConfig, helpers.STABLE)

        if not last_cloned_resource or st_config_resource.id != last_cloned_resource.st_source_id or ab_config_resource.id != last_cloned_resource.ab_source_id:
            self.clone(st_config_resource, ab_config_resource)

    def clone(self, st_config_resource, ab_config_resource):
        st_config_path = sdk2.ResourceData(st_config_resource).path.joinpath("select_type.json").as_posix()
        ab_config_path = sdk2.ResourceData(ab_config_resource).path.as_posix()

        resource = CryptaBigbExperimentConfig(
            self,
            "BigB experiment configs",
            "configs.tar.gz",
            ttl=st_config_resource.ttl,
            released=helpers.PRESTABLE,
            st_source_id=st_config_resource.id,
            ab_source_id=ab_config_resource.id,
        )

        resource_data = sdk2.ResourceData(resource)
        with tarfile.open(resource_data.path.as_posix(), "w:gz") as tar:
            tar.add(st_config_path, "select_type.json")
            tar.add(ab_config_path, "ab_config.json")

        resource_data.ready()

    def on_success(self, prev_status):
        status = "OK"
        description = "OK"
        host = "crypta-sandbox"
        service = "CryptaCloneBigbExperimentConfig"
        jclient.send_events_to_juggler(host, service, status, description)
        self.set_info("Send juggler event. Host='{}', service='{}', status='{}', description='{}'".format(host, service, status, description))

    @classmethod
    def get_class_juggler_service(cls):
        return cls.__name__
