from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task
)


class CryptaCmCalcExpireBundle(sdk2.Resource):
    releasable = True


class CryptaCmCalcExpireTask(task.CryptaTask):

    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaCmCalcExpireBundle
        templates = ["config.yaml"]
        cmd = [
            helpers.get_abspath("crypta-cm-calc-expire"),
            "--config", helpers.get_abspath("config.yaml")
        ]

    class Parameters(task.CryptaTask.Parameters):
        installation = sdk2.parameters.String("Installation name", required=True)

    def render_template(self, template):
        helpers.render_template(
            template,
            environment=self.Parameters.environment,
            installation=self.Parameters.installation,
        )

    def get_graphite_monitoring_task_name(self):
        return self.__class__.__name__
