from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task
)


class CryptaCmDbBackupBundle(sdk2.Resource):
    releasable = True


class CryptaCmDbBackupTask(task.CryptaTask):

    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaCmDbBackupBundle
        templates = ["config.yaml"]
        cmd = [
            helpers.get_abspath("crypta-cm-db-backup"),
            "--config", helpers.get_abspath("config.yaml")
        ]

    def get_graphite_monitoring_task_name(self):
        return self.__class__.__name__
