from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task
)


class CryptaCmDbStatsBundle(sdk2.Resource):
    releasable = True


class CryptaCmDbStatsTask(task.CryptaTask):

    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaCmDbStatsBundle
        templates = ["config.yaml"]
        cmd = [
            helpers.get_abspath("crypta-cm-db-stats"),
            "--config", helpers.get_abspath("config.yaml")
        ]

    def get_graphite_monitoring_task_name(self):
        return self.__class__.__name__
