from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task,
    vault
)


TVM_SECRETS = {
    helpers.STABLE: "sec-01dq7mhehy91k5gzxz7ngkc0db[client_secret]",
    helpers.TESTING: "sec-01dq7mheb44qtydwtvene6y7bh[client_secret]"
}


class CryptaCmExtIdMapperBundle(sdk2.Resource):
    releasable = True


class CryptaCmExtIdMapperTask(task.CryptaTask):

    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaCmExtIdMapperBundle
        templates = ["config.yaml"]
        cmd = [
            helpers.get_abspath("crypta-cm-ext-id-mapper"),
            "--config", helpers.get_abspath("config.yaml")
        ]

    class Parameters(task.CryptaTask.Parameters):
        installation = sdk2.parameters.String("Installation name", required=True)
        handle = sdk2.parameters.String("Handle in CM service", required=True)
        subclient = sdk2.parameters.String("Subclient for requests to CM", required=True)

    def render_template(self, template):
        helpers.render_template(
            template,
            environment=self.Parameters.environment,
            installation=self.Parameters.installation,
            handle=self.Parameters.handle,
            subclient=self.Parameters.subclient,
        )

    def get_graphite_monitoring_task_name(self):
        return self.__class__.__name__

    def get_additional_env(self):
        return {
            "TVM_SECRET": vault.get_vault_item(TVM_SECRETS[self.Parameters.environment])
        }

    @classmethod
    def get_juggler_service_with_suffix(cls, suffix):
        return "{}_{}".format(cls.get_class_juggler_service(), suffix)

    def get_juggler_service(self):
        return self.get_juggler_service_with_suffix(self.Parameters.handle)
