from sandbox.projects.crypta.common import (
    helpers,
    task
)
from sandbox.projects.crypta.cm.offline import bundle


class CryptaOfflineCmParseCmAccessLogTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = bundle.CryptaOfflineCmConfigBundle
        cmd = [
            helpers.get_abspath("crypta-offline-cm-parse-cm-access-log"),
            "--config", helpers.get_abspath(bundle.CONFIG_FILENAME)
        ]

    def get_graphite_monitoring_task_name(self):
        return self.__class__.__name__

    def on_prepare(self):
        super(CryptaOfflineCmParseCmAccessLogTask, self).on_prepare()
        helpers.render_template(bundle.CONFIG_FILENAME, environment=self.Parameters.environment, task=self.__class__.__name__)
        bundle.download_binary_bundle(self)
