import yaml

from sandbox.projects.crypta.common import (
    helpers,
    task
)
from sandbox.projects.crypta.cm.offline import bundle


class CryptaOfflineCmSplitByTagTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = bundle.CryptaOfflineCmConfigBundle
        templates = [bundle.INDEX_FILENAME]
        cmd = [
            helpers.get_abspath("crypta-offline-cm-split-by-tag"),
            "--config", helpers.get_abspath(bundle.CONFIG_FILENAME)
        ]

    def get_graphite_monitoring_task_name(self):
        return self.__class__.__name__

    def on_prepare(self):
        super(CryptaOfflineCmSplitByTagTask, self).on_prepare()

        with open(bundle.INDEX_FILENAME) as f:
            index = yaml.load(f)

        helpers.render_template(bundle.CONFIG_FILENAME, environment=self.Parameters.environment, task=self.__class__.__name__,  tags=[item["tag"] for item in index])
        bundle.download_binary_bundle(self)
