from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task
)
from sandbox.projects.crypta.cm.offline import bundle


class CryptaOfflineCmUpdateStateTask(task.CryptaTask):
    class Parameters(task.CryptaTask.Parameters):
        tag = sdk2.parameters.String(
            "Cookie matching tag",
            required=True
        )
        ttl = sdk2.parameters.Integer(
            "TTL",
            required=True
        )

    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = bundle.CryptaOfflineCmConfigBundle
        cmd = [
            helpers.get_abspath("crypta-offline-cm-update-state"),
            "--config", helpers.get_abspath(bundle.CONFIG_FILENAME)
        ]

    def get_graphite_monitoring_task_name(self):
        return "{}__{}".format(self.__class__.__name__, self.Parameters.tag)

    def get_semaphore_name(self):
        return "{}_{}".format(super(CryptaOfflineCmUpdateStateTask, self).get_semaphore_name(), self.Parameters.tag)

    def get_juggler_service(self):
        return self.get_juggler_service_for_tag(self.Parameters.tag)

    def on_prepare(self):
        super(CryptaOfflineCmUpdateStateTask, self).on_prepare()
        helpers.render_template(bundle.CONFIG_FILENAME, environment=self.Parameters.environment, task=self.__class__.__name__, tag=self.Parameters.tag, ttl=self.Parameters.ttl)
        bundle.download_binary_bundle(self)

    @classmethod
    def get_juggler_service_for_tag(cls, tag):
        return "{}_{}".format(cls.get_class_juggler_service(), tag)
