from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task
)


class CryptaCmPrepareToSyncDbBundle(sdk2.Resource):
    releasable = True


class CryptaCmPrepareToSyncDbTask(task.CryptaTask):

    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaCmPrepareToSyncDbBundle
        templates = ["config.yaml"]
        cmd = [
            helpers.get_abspath("crypta-cm-prepare-to-sync-db"),
            "--config", helpers.get_abspath("config.yaml")
        ]

    def get_graphite_monitoring_task_name(self):
        return self.__class__.__name__
