from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task,
    vault
)


CRYPTA_CM_UPLOADER_TVM_SECRET = {
    helpers.STABLE: "sec-01dq7mhehy91k5gzxz7ngkc0db[client_secret]",
    helpers.TESTING: "sec-01dq7mheb44qtydwtvene6y7bh[client_secret]"
}


class CryptaCmUploaderBundle(sdk2.Resource):
    releasable = True


class CryptaCmUploaderTask(task.CryptaTask):

    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaCmUploaderBundle
        templates = ["config.yaml"]
        cmd = [
            helpers.get_abspath("crypta-cm-uploader"),
            "--config", helpers.get_abspath("config.yaml")
        ]

    def get_graphite_monitoring_task_name(self):
        return self.__class__.__name__

    def get_additional_env(self):
        return {
            "TVM_SECRET": vault.get_vault_item(CRYPTA_CM_UPLOADER_TVM_SECRET[self.Parameters.environment])
        }
