from sandbox import sdk2

from sandbox.projects.crypta.common.helpers import RELEASE_STATUS, TESTING


class CryptaBasicTask(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):

        with sdk2.parameters.Group("Overrides") as overrides_group:
            override_basic_params = sdk2.parameters.Bool(
                "Override basic params",
                default_value=False
            )

            with override_basic_params.value[True]:
                override_use_monitor = sdk2.parameters.Bool(
                    "Use monitor",
                    default_value=False
                )

                with override_use_monitor.value[True]:
                    overridden_monitor = sdk2.parameters.String(
                        "Monitor"
                        # required=True
                    )

                override_send_juggler_events = sdk2.parameters.Bool(
                    "Send juggler event",
                    default_value=False
                )

                with override_send_juggler_events.value[True]:
                    override_juggler_host = sdk2.parameters.String(
                        "Juggler host"
                    )

                    override_juggler_service = sdk2.parameters.String(
                        "Juggler service"
                    )

                overridden_semaphore = sdk2.parameters.String(
                    "Semaphore"
                    # required=True
                )

                overridden_bundle_resource = sdk2.parameters.Resource(
                    "Bundle resource"
                    # required=True
                )

        user_crypta_api_params = sdk2.parameters.Dict("Crypta API parameters")

        with sdk2.parameters.Group("Task params") as task_params_group:
            environment = sdk2.parameters.String(
                "Environment",
                required=True,
                choices=[(x, x) for x in RELEASE_STATUS],
                default_value=TESTING
            )

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        disk_space = 1024
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass
