import tempfile

from sandbox.projects.crypta.common import vault


def get_password_file(login):
    with tempfile.NamedTemporaryFile('w', delete=False) as password_file:
        password_file.write(get_ftp_password(login))
    return password_file.name


def get_ftp_password(login):
    return vault.get_vault_item("sec-01cskgwk8t99p303322vzkg2w1[{}]".format(login))
