from sandbox import sdk2


def get_bundle_dict():
    return {cls.__name__: cls for cls in sdk2.Resource.__subclasses__()}


class ResourceSelector(sdk2.parameters.String):

    """ Selector of bundle resources """

    choices = list((key, key) for key in get_bundle_dict())

    @classmethod
    def cast(cls, value):
        if value is not None and value not in get_bundle_dict():
            raise ValueError("Wrong value: {!r}".format(value))
        return value
