import tempfile

from sandbox import sdk2

from sandbox.projects.crypta.common.helpers import (
    STABLE,
    TESTING
)


VAULT_OWNER = "CRYPTA"
# Note: yav tokens should be accessible both for robot-crypta and robot-crypta-testing

YT_TOKEN = {
    STABLE: "sec-01csvzgg3mdasmdygkr5s8n6mz[token]",
    TESTING: "sec-01csvzht1xqae2t7djkh0kjzrm[token]",
}
YQL_TOKEN = {
    STABLE: "sec-01csvzgez8yspn3wmr973hhsqk[secret]",
    TESTING: "sec-01csvzhrwp51f2tm9v8rfv8vkp[token]",
}
YDB_TOKEN = {
    STABLE: "sec-01djmv2qmccj7dz58gasvrkrvf[token]",
    TESTING: "sec-01dp0sf3f5a7g16v48x7r674gr[token]",
}
SNBX_TOKEN = {
    STABLE: "sec-01csvzg7vtpvb7bgrx18ajsscj[token]",
    TESTING: "sec-01csvzhpgr21ag94stm56y2h66[token]",
}
SOLOMON_TOKEN = "sec-01e63xgmh8g9fj3c542hrw9vqc[token]"
CRYPTA_API_TOKEN = "sec-01csvzfvrmwscwvt2j9ms2wr2z[oauth]"
ROBOT_CRYPTA_STATFACE_TOKEN = "sec-01daxg3xp40d5pr2s52sb22pkm[secret]"
ROBOT_CRYPTA_REACTOR_TOKEN = "sec-01ep4xy1ysb2kw1qkxm8nz3n33[token]"
CRYPTA_API_TVM_SETTINGS = {
    STABLE: {
        "secret_name": "sec-01dq7kz5emy5zj646zf0ts5x6m[client_secret]",
        "id": 2000759,
    },
    TESTING: {
        "secret_name": "sec-01dq7kz5q14htz2gzqjqraxxdg[client_secret]",
        "id": 2000761,
    },
}


def get_vault_item(item_name, vault_owner=VAULT_OWNER):
    return sdk2.Vault.data(vault_owner, item_name)


def get_file_with_vault_item(item_name):
    with tempfile.NamedTemporaryFile('wb', delete=False) as f:
        f.write(get_vault_item(item_name))
    return f.name


def get_yt_token(environment):
    return get_vault_item(YT_TOKEN[environment])


def get_yql_token(environment):
    return get_vault_item(YQL_TOKEN[environment])


def get_ydb_token(environment):
    return get_vault_item(YDB_TOKEN[environment])


def get_snbx_token(environment):
    return get_vault_item(SNBX_TOKEN[environment])


def get_solomon_token():
    return get_vault_item(SOLOMON_TOKEN)


def get_crypta_api_token():
    return get_vault_item(CRYPTA_API_TOKEN)


def get_statface_token():
    return get_vault_item(ROBOT_CRYPTA_STATFACE_TOKEN)


def get_reactor_token():
    return get_vault_item(ROBOT_CRYPTA_REACTOR_TOKEN)


def get_crypta_api_tvm_settings(environment):
    return {
        "id": CRYPTA_API_TVM_SETTINGS[environment]["id"],
        "secret": get_vault_item(CRYPTA_API_TVM_SETTINGS[environment]["secret_name"]),
    }
