import os

from sandbox.projects.crypta.common import (
    task,
    vault,
)

from sandbox.projects.crypta.dit import bundle


WORK_DIR = "work_dir"


class CryptaDitExportDataTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = bundle.CryptaDitBundle
        templates = ["config.yaml"]
        use_semaphore = True
        graphite_monitoring_task_name = "ext_dmp_segments__ditmsk_export_data_sh"

    def get_cmd(self):
        password_file = vault.get_file_with_vault_item("sec-01csks2wbyqdvdmed2r3kbezg6[password]")
        os.mkdir(WORK_DIR)

        return [
            os.path.abspath("mr_dit_process"),
            "export_data",
            "--config", os.path.abspath("config.yaml"),
            "--log-config", os.path.abspath("logger.conf"),
            "--ftp-password-file", password_file,
            "--local-work-dir", os.path.abspath(WORK_DIR)
        ]
