from sandbox.projects.crypta.common import (
    helpers,
    task,
)

from sandbox.projects.crypta.dit import bundle


class CryptaDitMatchToSegmentsAndDomainsTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = bundle.CryptaDitBundle
        templates = ["config.yaml"]
        cmd = [
            helpers.get_abspath("mr_dit_process"),
            "match_dit_to_segments_and_domains",
            "--config", helpers.get_abspath("config.yaml"),
            "--log-config", helpers.get_abspath("logger.conf")
        ]
        use_semaphore = True
        graphite_monitoring_task_name = "ext_dmp_segments__ditmsk_match_dit_to_segments_and_domains_sh"
