import os

from sandbox.projects.crypta.common import (
    task,
    vault,
)

from sandbox.projects.crypta.dit import bundle


WORK_DIR = "work_dir"


class CryptaDitSftpToYtDailyTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = bundle.CryptaDitBundle
        templates = ["config.yaml"]
        use_semaphore = True
        graphite_monitoring_task_name = "ext_dmp_segments__ditmsk_sftp_to_yt_daily_sh"

    def get_cmd(self):
        sftp_key_file = vault.get_file_with_vault_item("sec-01ebz9fwxmbjhbngx6w5xas6xn[secret]")
        os.mkdir(WORK_DIR)

        return [
            os.path.abspath("mr_dit_process"),
            "sftp_to_yt_daily",
            "--config", os.path.abspath("config.yaml"),
            "--log-config", os.path.abspath("logger.conf"),
            "--sftp-key-file", sftp_key_file,
            "--local-work-dir", os.path.abspath(WORK_DIR)
        ]
