import os

from sandbox.projects.crypta.common import (
    helpers,
    vault,
)
from sandbox.projects.crypta.dmp.adobe.common import task


class CryptaAdobeProcessSegmentsTask(task.CryptaAdobeTask):
    def get_cmd(self):
        cmd = [
            os.path.abspath("crypta-run-flow"),
            "--config", os.path.abspath("config.yaml"),
            "--bin", os.path.abspath("crypta-adobe-transfer-bindings-to-yt"),
            "--bin", os.path.abspath("crypta-adobe-parse-raw-bindings"),
            "--bin", os.path.abspath("crypta-adobe-update-bindings"),
            "--bin", os.path.abspath("crypta-adobe-match-cookies"),
            "--bin", os.path.abspath("crypta-adobe-filter-eu-yandexuids"),
            "--bin", os.path.abspath("crypta-adobe-transfer-meta-to-yt"),
        ]

        if self.Parameters.environment == helpers.STABLE:
            cmd += ["--bin", os.path.abspath("crypta-adobe-upload-to-audience")]

        return cmd

    def get_additional_env(self):
        default_api_oauth2_sec = "sec-01ctn4ashd491keqjdxskqh4vm"
        custom_api_oauth2_secs = {
            "unilever": "sec-01fb9ghkw3wh9jhnk3xnjbczn7",
        }

        api_oauth2_sec = custom_api_oauth2_secs.get(self.Parameters.customer, default_api_oauth2_sec)

        return {
            "CRYPTA_ADOBE_API_CLIENT_ID": vault.get_vault_item("{}[client_id]".format(api_oauth2_sec)),
            "CRYPTA_ADOBE_API_SECRET": vault.get_vault_item("{}[secret]".format(api_oauth2_sec)),
            "CRYPTA_ADOBE_API_USER": vault.get_vault_item("sec-01eb1jpv4pqpzbd9rn9bnbps56[{}]".format(self.Parameters.customer)),
            "CRYPTA_ADOBE_API_PASSWORD": vault.get_vault_item("sec-01eb1jn11qsszmf43f4mmfymxb[{}]".format(self.Parameters.customer)),

            "CRYPTA_ADOBE_S3_KEY": vault.get_vault_item("sec-01cva2hse3xahmn7145y7rh5x5[access_key_id]"),
            "CRYPTA_ADOBE_S3_SECRET": vault.get_vault_item("sec-01cva2hse3xahmn7145y7rh5x5[secret_access_key]"),

            "UPLOAD_AUDIENCE_TVM_SECRET": vault.get_vault_item("sec-01dq7mn0thkkxkzdjsc56q0mgx[client_secret]"),
            "SHARE_AUDIENCE_OAUTH_TOKEN": vault.get_vault_item("sec-01eb1j3w59x9j77z593ssehd92[{}]".format(self.Parameters.customer)),
        }
