from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task
)


class CryptaDmpUploadToLogbrokerBundle(sdk2.Resource):
    releasable = True


class CryptaDmpUploadToLogbrokerTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaDmpUploadToLogbrokerBundle
        templates = ["config.yaml"]
        cmd = [
            helpers.get_abspath("run_upload_to_logbroker"),
            "--config", helpers.get_abspath("config.yaml"),
            "--bin", helpers.get_abspath("upload_to_logbroker")
        ]
        graphite_monitoring_task_name = "ext_dmp_segments__upload_to_logbroker_sh"

    class Parameters(task.CryptaTask.Parameters):
        _container = sdk2.parameters.Container("Container with push-client", required=True)
