import os

from sandbox import sdk2

from sandbox.projects.crypta.common import helpers


class CryptaDmpYandexConfigBundle(sdk2.Resource):
    releasable = True


class CryptaDmpYandexBinaryBundle(sdk2.Resource):
    releasable = True


def download_binary_bundle(task):
    bundle = helpers.get_last_released_resource(CryptaDmpYandexBinaryBundle, task.Parameters.environment)
    bundle_path = helpers.download_resource(bundle)
    helpers.untar_path(bundle_path)

    task.set_info(str(bundle))
    task.set_info(os.path.basename(bundle_path))
