import yaml

from sandbox import sdk2
from sandbox.projects.crypta.common import (
    helpers,
    task
)
from sandbox.projects.crypta.dmp.yandex.common import bundle


INDEX_FILENAME = "index.yaml"
CONFIG_FILENAME = "config.yaml"


class CryptaDmpYandexTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = bundle.CryptaDmpYandexConfigBundle
        templates = [INDEX_FILENAME]

    class Parameters(task.CryptaTask.Parameters):
        login = sdk2.parameters.String(
            "DMP login",
            required=True
        )

    def get_semaphore_name(self):
        return "{}_{}".format(super(CryptaDmpYandexTask, self).get_semaphore_name(), self.Parameters.login)

    def get_juggler_service(self):
        return self.get_juggler_service_for_login(self.Parameters.login)

    def get_graphite_monitoring_task_name(self):
        return "{}__{}".format(self.__class__.__name__, get_short_dmp_name(self.Parameters.login))

    def on_prepare(self):
        super(CryptaDmpYandexTask, self).on_prepare()

        with open(INDEX_FILENAME) as f:
            index = yaml.load(f)

        context = get_context(index, self.Parameters.login)
        helpers.render_template(CONFIG_FILENAME, environment=self.Parameters.environment, **context)

        with open(CONFIG_FILENAME) as f:
            self.config = yaml.load(f)

        bundle.download_binary_bundle(self)

    @classmethod
    def get_juggler_service_for_login(cls, login):
        return "{}_{}".format(cls.get_class_juggler_service(), login)


def get_context(index, login):
    for context in index:
        if context["dmp_login"] == login:
            context["errors_emails"] = yaml.dump(context["errors_emails"]).strip("\n")
            context["stats_emails"] = yaml.dump(context["stats_emails"]).strip("\n")
            return context

    raise Exception("'{}' not found in index".format(login))


def get_short_dmp_name(login):
    prefix = "dmp-"
    return login[len(prefix):] if login.startswith(prefix) else login
