import os

from sandbox.projects.crypta.common import password
from sandbox.projects.crypta.dmp.yandex.common import task


class CryptaDmpYandexFtpToYtTask(task.CryptaDmpYandexTask):
    def get_cmd(self):
        return [
            os.path.abspath("crypta-dmp-yandex-ftp-to-yt"),
            "--config", os.path.abspath("config.yaml"),
        ]

    def get_additional_env(self):
        return {
            "CRYPTA_DMP_FTP_PASSWORD": password.get_ftp_password(self.config["ftp-user"]),
            "YT_LOG_LEVEL": "DEBUG",
        }
