from sandbox.projects.crypta.common import (
    helpers,
    task,
)
from sandbox.projects.crypta.dmp.yandex.common import bundle


CONFIG = "mac_hash_yuid_maker.yaml"


class CryptaDmpYandexMakeMacHashYuidTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = bundle.CryptaDmpYandexConfigBundle
        templates = [CONFIG]
        cmd = [
            helpers.get_abspath("crypta-dmp-yandex-make-mac-hash-yuid"),
            "--config", helpers.get_abspath(CONFIG),
        ]

    def on_prepare(self):
        super(CryptaDmpYandexMakeMacHashYuidTask, self).on_prepare()
        bundle.download_binary_bundle(self)
