from sandbox.projects.crypta.common import (
    helpers,
    task,
)
from sandbox.projects.crypta.dmp.yandex.common import bundle


CONFIG = "index_publisher.yaml"
INDEX = "index.yaml"


class CryptaDmpYandexPublishIndexTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = bundle.CryptaDmpYandexConfigBundle
        templates = [INDEX, CONFIG]
        cmd = [
            helpers.get_abspath("crypta-dmp-yandex-publish-index"),
            "--config", helpers.get_abspath(CONFIG),
            "--index", helpers.get_abspath(INDEX),
        ]
        graphite_monitoring_task_name = "CryptaDmpYandexPublishIndexTask"

    def on_prepare(self):
        super(CryptaDmpYandexPublishIndexTask, self).on_prepare()
        bundle.download_binary_bundle(self)
