from sandbox.projects.crypta.common import (
    helpers,
    vault
)
from sandbox.projects.crypta.dmp.yandex.common import (
    helpers as dmp_helpers,
    task
)


class CryptaDmpYandexSendMetricsTask(task.CryptaDmpYandexTask):
    class CryptaOptions(task.CryptaDmpYandexTask.CryptaOptions):
        cmd = [
            helpers.get_abspath("crypta-dmp-yandex-send-metrics"),
            "--config", helpers.get_abspath("config.yaml")
        ]

    def get_additional_env(self):
        return {
            "CRYPTA_API_TOKEN": vault.get_crypta_api_token(),
            "CRYPTA_DMP_AUDIENCE_OAUTH_TOKEN": vault.get_vault_item(dmp_helpers.get_dmp_audience_oauth_token_name(self.Parameters.login))
        }
