from sandbox.projects.crypta.common import (
    helpers,
    password,
)
from sandbox.projects.crypta.dmp.yandex.common import task


class CryptaDmpYandexUploadReportToFtpTask(task.CryptaDmpYandexTask):
    class CryptaOptions(task.CryptaDmpYandexTask.CryptaOptions):
        cmd = [
            helpers.get_abspath("crypta-dmp-yandex-upload-report-to-ftp"),
            "--config", helpers.get_abspath("config.yaml"),
        ]

    def get_additional_env(self):
        return {
            "CRYPTA_DMP_FTP_PASSWORD": password.get_ftp_password(self.config["ftp-user"]),
        }
