import os

from sandbox.projects.crypta.common import vault
from sandbox.projects.crypta.dmp.yandex.common import (
    helpers,
    task
)


class CryptaDmpYandexUploadToAudienceTask(task.CryptaDmpYandexTask):
    def get_cmd(self):
        return [
            os.path.abspath("crypta-dmp-yandex-upload-to-audience"),
            "--config", os.path.abspath("config.yaml")
        ]

    def get_additional_env(self):
        return {
            "UPLOAD_AUDIENCE_TVM_SECRET": vault.get_vault_item("sec-01dq7mn0thkkxkzdjsc56q0mgx[client_secret]"),
            "SHARE_AUDIENCE_OAUTH_TOKEN": vault.get_vault_item(helpers.get_dmp_audience_oauth_token_name(self.Parameters.login))
        }
