import os

from sandbox import sdk2

from sandbox.projects.crypta.common.task import CryptaTask
from sandbox.projects.crypta.common import helpers
from sandbox.projects.crypta.common.helpers import TESTING


class CryptaGraphExportBundle(sdk2.Resource):
    releasable = True


class CryptaGraphExport(CryptaTask):

    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaGraphExportBundle
        graphite_monitoring_task_name = "crypta-graph-export"
        use_semaphore = True
        report_status_to_crypta_api = True

    class Parameters(CryptaTask.Parameters):
        version = sdk2.parameters.String("Version", required=True, choices=[(x, x) for x in ('v1', 'v2', 'exp')])
        diff = sdk2.parameters.Bool("Export diff only", default_value=False)
        pool = sdk2.parameters.String("YT pool", default_value='crypta_all')
        source = sdk2.parameters.String("source", default_value='')
        destination = sdk2.parameters.String("destination root", default_value='')

    def get_bundle_resource(self):
        if str(self.Parameters.version) == "exp":
            # always prefer testing build in experiment
            return helpers.get_last_released_resource(self.CryptaOptions.bundle_resource_type, TESTING)
        else:
            return super(CryptaGraphExport, self).get_bundle_resource()

    def get_additional_env(self):
        return {
            'ENVIRONMENT': self.Parameters.environment.replace('stable', 'production'),
            'YT_POOL': self.Parameters.pool,
        }

    def get_crypta_api_params(self):
        return {
            "version": self.Parameters.version,
        }

    @classmethod
    def get_juggler_service_for_version(self, version):
        return "{}_{}".format(self.get_class_juggler_service(), version)

    def get_juggler_service(self):
        return self.get_juggler_service_for_version(self.Parameters.version)

    def get_semaphore_name(self):
        semaphore_name = super(CryptaGraphExport, self).get_semaphore_name()
        suffix = str(self.Parameters.version)
        return "{}_{}".format(semaphore_name, suffix)

    def get_cmd(self):
        result = [
            os.path.abspath("export"),
            self.Parameters.version,
            str(int(self.Parameters.diff)),
        ]
        if self.Parameters.destination:
            result.extend([self.Parameters.source, self.Parameters.destination])
        return result
