from sandbox import sdk2
from sandbox.projects.crypta.common.task import CryptaBaseYqlTask


class CryptaFingerprintBundle(sdk2.Resource):
    releasable = True


class CryptaFpBaseTask(CryptaBaseYqlTask):

    """ Base fingerprint task """

    BIN_FILE_NAME = "crypta-fingerprint"
    YT_POOL = "crypta_graph"

    class CryptaOptions(CryptaBaseYqlTask.CryptaOptions):

        bundle_resource_type = CryptaFingerprintBundle
        use_semaphore = True
        report_status_to_crypta_api = True

    def get_semaphore_name(self):
        semaphore_name = super(CryptaFpBaseTask, self).get_semaphore_name()
        return "{}_{}".format(semaphore_name, self.Parameters.task or self.TASK)
