from sandbox import sdk2

from sandbox.projects.crypta.common.task import CryptaTask
from sandbox.projects.crypta.common.vault import get_statface_token

import os

MODES = (
    'build_fingerprints',
    'get_fpc_from_chevent_log',
    'get_fpc_from_watch_log',
    'get_fpc_via_zen',
    'get_fpc_via_serp',
    'get_fpc_via_yclid',
    'get_fpc_via_market',
    'get_fpc_via_tls',
    'get_fpc_via_cookie_sync',
    'get_fpc_via_fingerprint',
    'get_fpc_from_sovetnik',
    'get_fpc_from_zakladki',
    'get_fpc_via_mc_port',
    'get_fpc_via_extfp',
    'get_fpc_from_mts',
    'hourly',
    'daily',
    'calculate_sources',
    'update_keyboard_uuids',
)


class CryptaGraphFpcBundle(sdk2.Resource):
    releasable = True


class CryptaGraphFpc(CryptaTask):

    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaGraphFpcBundle
        use_semaphore = False

    class Parameters(CryptaTask.Parameters):
        export = sdk2.parameters.Bool('Export to IS')
        pool = sdk2.parameters.String('YT pool', default_value='crypta_graph')
        mode = sdk2.parameters.String(
            'Mode',
            required=True,
            choices=[(x, x) for x in MODES],
            default_value='hourly',
        )

    @classmethod
    def get_juggler_service_for_mode(cls, mode, export):
        suffix = mode
        if export:
            suffix += "_export"

        return "{}__{}".format(cls.get_class_juggler_service(), suffix)

    def get_juggler_service(self):
        return self.get_juggler_service_for_mode(self.Parameters.mode, self.Parameters.export)

    def get_additional_env(self):
        return {
            'CRYPTA_ENVIRONMENT': self.Parameters.environment.replace('stable', 'production').upper(),
            'ENV_TYPE': self.Parameters.environment.lower().replace('stable', 'production'),
            'ENVIRONMENT': self.Parameters.environment.replace('stable', 'production'),
            'YT_POOL': self.Parameters.pool,
            'STATFACE_TOKEN': get_statface_token(),
        }

    def get_cmd(self):
        cmd = [
            os.path.abspath('crypta_graph_fpc'),
            self.Parameters.mode,
        ]

        if self.Parameters.export:
            cmd.append('--export')

        return cmd
