import os

from sandbox.projects.crypta.common.helpers import STABLE, TESTING


def get_matching_env(env, is_exp=None):
    if env == TESTING:
        return {
            "YT_POOL": "crypta_graph_testing",
            "YT_POOL_MAX_OPS": "10",
            "YT_JAVA_TMP_DIR": "//home/crypta/testing/state/graph/v2/matching/java_tmp",
            "PATH": os.environ["PATH"],  # to pass java env
        }
    elif env == STABLE:
        if is_exp is None:
            return {
                "YT_POOL": "crypta_graph_human_matching_prepare",
                "YT_POOL_MAX_OPS": "10",
                "YT_JAVA_TMP_DIR": "//home/crypta/production/state/graph/v2/matching/java_tmp",
                "PATH": os.environ["PATH"],  # to pass java env
            }
        elif is_exp:
            return {
                "YT_POOL": "crypta_graph_human_matching_exp",
                "YT_POOL_MAX_OPS": "10",
                "YT_JAVA_TMP_DIR": "//home/crypta/production/state/graph/v2exp/matching/java_tmp",
                "PATH": os.environ["PATH"],  # to pass java env
            }
        else:
            return {
                "YT_POOL": "crypta_graph_human_matching_v2",
                "YT_POOL_MAX_OPS": "10",
                "YT_JAVA_TMP_DIR": "//home/crypta/production/state/graph/v2/matching/java_tmp",
                "PATH": os.environ["PATH"],  # to pass java env
            }
    else:
        raise Exception("%s env is not supported" % env)
