import os

from sandbox import sdk2
from sandbox.projects.crypta.common.task import CryptaTask
from sandbox.projects.crypta.common.vault import get_reactor_token


class CryptaGraphHumanMatchingBackupBuild(sdk2.Resource):
    releasable = True


class CryptaGraphHumanMatchingBackup(CryptaTask):
    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaGraphHumanMatchingBackupBuild
        graphite_monitoring_task_name = "crypta-graph-human-matching-backup"
        report_status_to_crypta_api = True

    class Parameters(CryptaTask.Parameters):
        kill_timeout = 60 * 60 * 8  # 8 hour

        yt_proxy = sdk2.parameters.String("YT proxy", default_value="hahn.yt.yandex.net", required=False)
        source_path = sdk2.parameters.String("YT path to HM vertices table", required=False)
        backup_dir_path = sdk2.parameters.String("Directory to backups for HM vertices tables", required=False)
        config = sdk2.parameters.String("Proto config path", required=False)

    def get_additional_env(self):
        env_type = self.Parameters.environment.replace("stable", "production").upper()
        return {"ENV_TYPE": env_type, "REACTOR_TOKEN": get_reactor_token(), "CRYPTA_ENVIRONMENT": env_type}

    def get_semaphore_name(self):
        semaphore_name = super(CryptaGraphHumanMatchingBackup, self).get_semaphore_name()
        return "{}_{}".format(semaphore_name, self.Parameters.config)

    def get_cmd(self):
        cmd = [os.path.abspath("archivator")]

        if self.Parameters.config:
            cmd.extend(["--config", os.path.abspath(self.Parameters.config.lstrip("/"))])

        if self.Parameters.yt_proxy:
            cmd.extend(["--yt-proxy", self.Parameters.yt_proxy])

        if self.Parameters.source_path:
            cmd.extend(["--source", self.Parameters.source_path])

        if self.Parameters.backup_dir_path:
            cmd.extend(["--backup-dir", self.Parameters.backup_dir_path])

        return cmd
