import os
import datetime

from sandbox import sdk2

from sandbox.projects.crypta.common.task import CryptaTask
from sandbox.projects.crypta.common.vault import get_vault_item


class CryptaStatsBaseMetricsBundle(sdk2.Resource):

    releasable = True


class CryptaStatsBaseMetrics(CryptaTask):

    """ Export metrics from grafit and statface and import into crypta matching base metrics """

    class CryptaOptions(CryptaTask.CryptaOptions):

        bundle_resource_type = CryptaStatsBaseMetricsBundle
        use_semaphore = False
        report_status_to_crypta_api = True

    class Parameters(CryptaTask.Parameters):

        date = sdk2.parameters.String('Date', required=True)
        local = sdk2.parameters.Bool('Local report', default=False)
        source = sdk2.parameters.String(
            'Source (YT path to matching source table'
            ' Example: //home/crypta/production/state/graph/v2/matching/vertices_no_multi_profile'
            ' Allow {date} placeholder)', required=True)
        version = sdk2.parameters.String(
            'Version (Matching version Example: v1 or v2', required=True)
        options = sdk2.parameters.Dict('Additional params for run binary', required=False)

    def get_additional_env(self):
        env_type = self.Parameters.environment.replace('stable', 'production').upper()
        return {
            'ENV_TYPE': env_type,
            'AB_OAUTH_TOKEN': get_vault_item('sec-01ehpf71k9jtjdpcd2xjr2hemn[token]'),
            'STATFACE_OAUTH': get_vault_item('sec-01daxg3xp40d5pr2s52sb22pkm[secret]'),
            'ENVIRONMENT': env_type.lower(),
            'YT_PROXY': 'hahn.yt.yandex.net',
            'YT_POOL': 'crypta_graph'
        }

    def get_cmd(self):
        cmd = [
            os.path.abspath('stats-base'),
            '--date', self.Parameters.date or (
                datetime.date.today() - datetime.timedelta(days=3)).strftime('%Y-%m-%d'),
            '--source', self.Parameters.source,
            '--version', self.Parameters.version,
        ]
        for key, value in self.Parameters.options.items():
            cmd.extend([key])
            cmd.extend(value.split())
        if self.Parameters.local:
            cmd.extend(['--local'])
        return cmd
